import { BlockPermutation, EntityEquippableComponent, EquipmentSlot, GameMode, ItemStack, Player } from '@minecraft/server';
import { MinecraftBlockItemTypes } from '../item/MinecraftBlockItemTypes';
export class Helper {
  static compareVector3(v1, v2) {
    return v1.x === v2.x && v1.y === v2.y && v1.z === v2.z;
  }
  static stringifyVector3(v, includeCommas = false) {
    const c = includeCommas ? ',' : '';
    return `${v.x}${c} ${v.y}${c} ${v.z}`;
  }
  static isItemOrBlockItem(item) {
    if (MinecraftBlockItemTypes.includes(item.typeId)) {
      return true;
    }
    try {
      BlockPermutation.resolve(item.typeId);
      return false;
    } catch (_err) {
      return true;
    }
  }
  static decreaseMainhandItemStack(player, amount = 1) {
    const equipments = player.getComponent(EntityEquippableComponent.componentId);
    const mainhandItem = equipments.getEquipment(EquipmentSlot.Mainhand);
    const updatedItemAmount = mainhandItem.amount - amount;
    if (player.matches({ gameMode: GameMode.creative })) return;
    equipments.setEquipment(EquipmentSlot.Mainhand,
      updatedItemAmount !== 0 ?
        new ItemStack(mainhandItem.typeId, updatedItemAmount) :
        null
    );
  }
}